# Asteroids Web Game

A modern web-based implementation of the classic Asteroids arcade game with user authentication, score tracking, and leaderboards.

## Features

- **Classic Gameplay**: Navigate your spaceship through asteroid fields
- **Progressive Difficulty**: Game gets harder with each round
- **User Authentication**: Secure login and registration system
- **Score Tracking**: Automatic saving of game scores and statistics
- **Leaderboard**: Compete with other players for the top spot
- **Responsive Design**: Works on desktop and mobile devices
- **Security Features**: CSRF protection, rate limiting, secure sessions

## Technology Stack

- **Frontend**: HTML5 Canvas, JavaScript, CSS
- **Backend**: PHP 7.4+
- **Database**: MySQL/MariaDB
- **Security**: CSRF tokens, password hashing, rate limiting

## Installation

### Prerequisites

- PHP 7.4 or higher
- MySQL 5.7+ or MariaDB 10.3+
- Apache web server with mod_rewrite enabled
- SSL certificate (for production)

### Setup Instructions

1. **Clone or download the repository** to your web server directory

2. **Database Setup**:
   - Create a MySQL database
   - Import the database schema from the SQL files
   - Note: Keep SQL files locally, don't upload to production

3. **Configuration**:
   - Copy `config.env.example` to `config.env`
   - Update database credentials in `config.env`:

     ```env
     DB_HOST=localhost
     DB_NAME=your_database
     DB_USER=your_username
     DB_PASS=your_password
     ENVIRONMENT=production
     ```

4. **File Permissions**:

   ```bash
   chmod 644 *.php *.js *.css .htaccess
   chmod 600 config.env
   ```

5. **SSL Configuration**:
   - Install SSL certificate
   - Uncomment HTTPS redirect in `.htaccess`

## Game Controls

- **Arrow Keys**: Navigate spaceship
- **Spacebar**: Fire bullets
- **P**: Pause/Resume game

## Security Features

- Environment-based configuration (no hardcoded credentials)
- CSRF protection on all forms
- Input sanitization and validation
- Rate limiting on authentication endpoints
- Secure session management
- SQL injection prevention via prepared statements
- XSS protection headers
- Content Security Policy

## Project Structure

```plaintext
├── index.php           # Landing page
├── login.php          # User login
├── register.php       # User registration
├── game.php           # Main game page
├── game.js            # Game logic
├── save_game.php      # Score saving endpoint
├── db.php             # Database connection
├── config.php         # Configuration loader
├── csrf.php           # CSRF protection
├── rate_limiter.php   # Rate limiting
├── security_headers.php # Security headers
├── style.css          # Styling
└── .htaccess          # Apache configuration
```

## Production Deployment

See `DEPLOYMENT_CHECKLIST.md` for detailed production deployment instructions.

## Important Security Notes

- Never commit `config.env` to version control
- Always use HTTPS in production
- Regularly update PHP and dependencies
- Monitor failed login attempts
- Keep SQL files out of production server

## Browser Compatibility

- Chrome 90+
- Firefox 88+
- Safari 14+
- Edge 90+

## License

This project is for educational purposes. Feel free to modify and use as needed.

## Support

For issues or questions:

1. Check the deployment checklist
2. Verify database connectivity
3. Review PHP error logs
4. Ensure all required PHP extensions are installed

---

Version 1.0 - Production Ready
