import React, { useState } from 'react';
import './PlayerInfo.css';

const PlayerInfo = () => {
    const [showAvatarModal, setShowAvatarModal] = useState(false);
    
    // Mock user data - in real app this would come from props or context
    const userData = {
        displayName: 'Pilot',
        avatarUrl: null
    };

    return (
        <>
            <div className="player-info-side">
                <div 
                    className="player-avatar" 
                    onClick={() => setShowAvatarModal(true)}
                    style={{ cursor: 'pointer', position: 'relative' }}
                >
                    {userData.avatarUrl ? (
                        <img src={userData.avatarUrl} alt="Avatar" />
                    ) : (
                        <span style={{ fontSize: '24px' }}>👤</span>
                    )}
                    <div style={{
                        position: 'absolute', 
                        bottom: '-2px', 
                        right: '-2px', 
                        background: '#4CAF50', 
                        borderRadius: '50%', 
                        width: '12px', 
                        height: '12px', 
                        fontSize: '8px', 
                        display: 'flex', 
                        alignItems: 'center', 
                        justifyContent: 'center'
                    }}>
                        {userData.avatarUrl ? '📷' : '+'}
                    </div>
                </div>
                <div className="welcome-message">
                    Welcome, <a href="profile.php" style={{ color: '#4CAF50', textDecoration: 'none', fontWeight: 'bold' }}>
                        {userData.displayName}
                    </a>
                    <span className="logout-link"> | <a href="logout.php" style={{ color: '#ff6b6b', textDecoration: 'none' }}>Mission Complete</a></span>
                </div>
            </div>

            {showAvatarModal && (
                <div className="modal" style={{ display: 'flex' }}>
                    <div className="modal-content">
                        <div className="modal-header">
                            <h3>Upload Avatar</h3>
                            <span className="close" onClick={() => setShowAvatarModal(false)}>&times;</span>
                        </div>
                        <div className="current-avatar">
                            {userData.avatarUrl ? (
                                <img src={userData.avatarUrl} alt="Current Avatar" style={{ width: '80px', height: '80px', borderRadius: '50%', objectFit: 'cover' }} />
                            ) : (
                                <div style={{ width: '80px', height: '80px', borderRadius: '50%', background: '#333', display: 'flex', alignItems: 'center', justifyContent: 'center', fontSize: '40px' }}>👤</div>
                            )}
                        </div>
                        
                        <form>
                            <div className="upload-area">
                                <input type="file" accept="image/*" style={{ display: 'none' }} />
                                <div style={{ textAlign: 'center' }}>
                                    <p>📷 Click to upload new avatar</p>
                                </div>
                            </div>
                            <button type="button" className="btn" style={{ width: '100%', marginTop: '10px' }}>
                                Select File
                            </button>
                        </form>
                    </div>
                </div>
            )}
        </>
    );
};

export default PlayerInfo;
