#!/bin/bash

# Cosmic Defender Deployment Script for Namecheap Stellar Hosting

echo "🚀 Starting deployment for Cosmic Defender..."

# Build the React app
echo "📦 Building React app..."
npm run build

# Check if build was successful
if [ $? -eq 0 ]; then
    echo "✅ Build successful!"
else
    echo "❌ Build failed!"
    exit 1
fi

# Create deployment directory
echo "📁 Preparing deployment files..."
mkdir -p deploy

# Copy build files to deploy directory
cp -r build/* deploy/

# Copy .htaccess to deploy directory
cp .htaccess deploy/

echo "📋 Deployment files ready in 'deploy' directory:"
echo "   - All build files"
echo "   - .htaccess for server configuration"
echo ""
echo "📤 Upload the contents of the 'deploy' directory to your Namecheap hosting:"
echo "   1. Connect to your Namecheap cPanel"
echo "   2. Go to File Manager"
echo "   3. Navigate to your public_html directory"
echo "   4. Upload all files from the 'deploy' directory"
echo "   5. Make sure .htaccess is uploaded"
echo ""
echo "🌐 Your game will be available at your domain!"
echo ""
echo "🎮 Game Features:"
echo "   - Responsive design"
echo "   - Keyboard controls (Arrow keys + Space)"
echo "   - Progressive difficulty"
echo "   - Score tracking"
echo "   - Visual effects"
