@echo off
echo 🚀 Starting deployment for Cosmic Defender...

REM Build the React app
echo 📦 Building React app...
call npm run build

REM Check if build was successful
if %errorlevel% equ 0 (
    echo ✅ Build successful!
) else (
    echo ❌ Build failed!
    pause
    exit /b 1
)

REM Create deployment directory
echo 📁 Preparing deployment files...
if not exist deploy mkdir deploy

REM Copy build files to deploy directory
xcopy /E /I /Y build\* deploy\

REM Copy .htaccess to deploy directory
copy /Y .htaccess deploy\

echo.
echo 📋 Deployment files ready in 'deploy' directory:
echo    - All build files
echo    - .htaccess for server configuration
echo.
echo 📤 Upload the contents of the 'deploy' directory to your Namecheap hosting:
echo    1. Connect to your Namecheap cPanel
echo    2. Go to File Manager
echo    3. Navigate to your public_html directory
echo    4. Upload all files from the 'deploy' directory
echo    5. Make sure .htaccess is uploaded
echo.
echo 🌐 Your game will be available at your domain!
echo.
echo 🎮 Game Features:
echo    - Responsive design
echo    - Keyboard controls (Arrow keys + Space)
echo    - Progressive difficulty
echo    - Score tracking
echo    - Visual effects
echo.
pause
