<?php
require_once 'security_headers.php';
require 'db.php';
require_once 'csrf.php';
require_once 'security_logger.php';
session_start();

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$success = '';
$error = '';

// Get current user data
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch();

if ($_POST) {
    validateCSRF();
    
    $display_name = trim($_POST['display_name'] ?? '');
    $bio = trim($_POST['bio'] ?? '');
    
    try {
        $stmt = $pdo->prepare("UPDATE users SET display_name = ?, bio = ? WHERE id = ?");
        $stmt->execute([$display_name, $bio ?: null, $_SESSION['user_id']]);
        
        // Update session variables
        $_SESSION['display_name'] = $display_name ?: $_SESSION['username'];
        $_SESSION['bio'] = $bio;
        
        $success = "Profile updated successfully!";
        
        // Log profile update
        $securityLogger = new SecurityLogger($pdo);
        $securityLogger->logEvent('profile_update', $_SESSION['user_id'], $_SESSION['username'], 'User updated profile', 'low');
        
    } catch(PDOException $e) {
        error_log("Profile update error: " . $e->getMessage());
        $error = "Failed to update profile. Please try again.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Profile - Asteroids</title>
    <link rel="stylesheet" type="text/css" href="style.css">
    <style>
        .profile-container {
            max-width: 600px;
            margin: 50px auto;
            padding: 20px;
            background: linear-gradient(135deg, #0f0f23 0%, #1a1a2e 100%);
            border-radius: 10px;
            color: white;
        }
        
        .profile-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .avatar-preview {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            margin: 0 auto 20px;
            background: #333;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }
        
        .avatar-preview img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #4CAF50;
        }
        
        .form-group input,
        .form-group textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid #333;
            border-radius: 5px;
            background: rgba(255, 255, 255, 0.1);
            color: white;
            box-sizing: border-box;
        }
        
        .form-group textarea {
            min-height: 100px;
            resize: vertical;
        }
        
        .btn {
            background: #4CAF50;
            color: white;
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }
        
        .btn:hover {
            background: #45a049;
        }
        
        .nav-links {
            text-align: center;
            margin-top: 20px;
        }
        
        .nav-links a {
            color: #4CAF50;
            text-decoration: none;
            margin: 0 10px;
        }
        
        .nav-links a:hover {
            text-decoration: underline;
        }
        
        .success { color: #4CAF50; }
        .error { color: #f44336; }
    </style>
</head>
<body>
    <div class="profile-container">
        <div class="profile-header">
            <h2>Player Profile</h2>
            
            <div class="avatar-preview">
                <?php if (!empty($user['avatar_url'])): ?>
                    <img src="<?php echo htmlspecialchars($user['avatar_url']); ?>" alt="Avatar">
                <?php else: ?>
                    <div style="color: #666; font-size: 40px;">👤</div>
                <?php endif; ?>
            </div>
            
            <h3><?php echo htmlspecialchars($user['display_name'] ?: $user['username']); ?></h3>
            <p style="color: #666;">Member since: <?php echo date('M d, Y', strtotime($user['created_at'])); ?></p>
            <?php if ($user['last_login']): ?>
                <p style="color: #666;">Last login: <?php echo date('M d, Y H:i', strtotime($user['last_login'])); ?></p>
            <?php endif; ?>
        </div>
        
        <?php if ($success) echo "<p class='success'>" . htmlspecialchars($success) . "</p>"; ?>
        <?php if ($error) echo "<p class='error'>" . htmlspecialchars($error) . "</p>"; ?>
        
        <form method="post">
            <?php echo getCSRFField(); ?>
            
            <div class="form-group">
                <label for="display_name">Display Name:</label>
                <input type="text" id="display_name" name="display_name" 
                       value="<?php echo htmlspecialchars($user['display_name'] ?? ''); ?>" 
                       placeholder="How others see your name">
            </div>
            
            <div class="form-group">
                <label>Avatar:</label>
                <p style="color: #666; font-size: 14px;">Upload your avatar by clicking your profile picture in the game!</p>
            </div>
            
            <div class="form-group">
                <label for="bio">Bio:</label>
                <textarea id="bio" name="bio" placeholder="Tell other players about yourself..."><?php echo htmlspecialchars($user['bio'] ?? ''); ?></textarea>
            </div>
            
            <button type="submit" class="btn">Update Profile</button>
        </form>
        
        <div class="nav-links">
            <a href="game.php">🎮 Play Game</a>
            <a href="logout.php">🚪 Logout</a>
        </div>
    </div>
</body>
</html>
