<?php include '../components/header.php'; ?>

<style>
    .service-hero {
        background: linear-gradient(135deg, rgba(255, 102, 0, 0.1) 0%, rgba(204, 82, 0, 0.1) 100%);
        padding: 100px 0 60px;
        margin-top: 76px;
    }
    
    .service-icon {
        font-size: 4rem;
        color: var(--primary-color);
        margin-bottom: 1.5rem;
    }
    
    .service-features {
        background-color: #000000;
        border-radius: 10px;
        padding: 2rem;
        margin: 2rem 0;
        border: 2px solid var(--primary-color);
    }
    
    .feature-item {
        display: flex;
        align-items: flex-start;
        margin-bottom: 1rem;
    }
    
    .feature-item i {
        color: var(--primary-color);
        margin-right: 1rem;
        margin-top: 0.25rem;
    }
    
    .back-to-services {
        display: inline-flex;
        align-items: center;
        margin-bottom: 2rem;
        color: var(--primary-color);
        text-decoration: none;
    }
    
    .back-to-services:hover {
        text-decoration: underline;
    }
    
    .back-to-services i {
        transition: transform 0.3s ease;
        margin-right: 0.5rem;
    }
    
    .back-to-services:hover i {
        transform: translateX(-3px);
    }
</style>

<!-- Hero Section -->
<section class="service-hero">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <a href="../index.php#services" class="back-to-services">
                    <i class="fas fa-arrow-left"></i> Back to All Services
                </a>
                <div class="service-icon">
                    <i class="fas fa-wifi"></i>
                </div>
                <h1>Wi-Fi Network Installation</h1>
                <p class="lead">Professional Wi-Fi network setup and optimization for homes and businesses in East Weymouth</p>
            </div>
        </div>
    </div>
</section>

<!-- Service Content -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="service-content">
                    <h2>About This Service</h2>
                    <p>Get reliable, high-speed Wi-Fi coverage throughout your home or office with our professional Wi-Fi network installation service. We design and implement custom wireless solutions that eliminate dead zones, provide fast and stable connections, and ensure your network is secure and optimized for all your devices.</p>
                    
                    <div class="service-features">
                        <h3>Our Wi-Fi Installation Includes</h3>
                        <ul class="list-unstyled">
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Site Survey & Planning</h5>
                                    <p class="mb-0 text-muted">We analyze your space to determine optimal router placement and coverage areas.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Equipment Selection</h5>
                                    <p class="mb-0 text-muted">We recommend and install the right equipment for your specific needs and space.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Network Configuration</h5>
                                    <p class="mb-0 text-muted">Professional setup of your wireless network with optimal security settings.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Device Connection</h5>
                                    <p class="mb-0 text-muted">We'll help connect and test all your devices on the new network.</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    
                    <h3>Why Choose Our Wi-Fi Service?</h3>
                    <p>Professional Wi-Fi installation ensures you get the performance and reliability you need. Our service includes comprehensive testing, security setup, and ongoing support to keep your network running at its best.</p>
                    
                    <div class="mt-5 text-center">
                        <a href="../index.php#quote" class="btn btn-primary btn-lg">Schedule Wi-Fi Installation</a>
                        <p class="mt-3 text-muted">Have questions? Call us at <a href="tel:6173026011">(617) 302-6011</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include '../components/footer.php'; ?>
