<?php include '../components/header.php'; ?>

<style>
    .service-hero {
        background: linear-gradient(135deg, rgba(255, 102, 0, 0.1) 0%, rgba(204, 82, 0, 0.1) 100%);
        padding: 100px 0 60px;
        margin-top: 76px;
    }
    
    .service-icon {
        font-size: 4rem;
        color: var(--primary-color);
        margin-bottom: 1.5rem;
    }
    
    .service-features {
        background-color: #000000;
        border-radius: 10px;
        padding: 2rem;
        margin: 2rem 0;
        border: 2px solid var(--primary-color);
    }
    
    .feature-item {
        display: flex;
        align-items: flex-start;
        margin-bottom: 1rem;
    }
    
    .feature-item i {
        color: var(--primary-color);
        margin-right: 1rem;
        margin-top: 0.25rem;
    }
    
    .back-to-services {
        display: inline-flex;
        align-items: center;
        margin-bottom: 2rem;
        color: var(--primary-color);
        text-decoration: none;
    }
    
    .back-to-services:hover {
        text-decoration: underline;
    }
    
    .back-to-services i {
        transition: transform 0.3s ease;
        margin-right: 0.5rem;
    }
    
    .back-to-services:hover i {
        transform: translateX(-3px);
    }
</style>

<!-- Hero Section -->
<section class="service-hero">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <a href="../index.php#services" class="back-to-services">
                    <i class="fas fa-arrow-left"></i> Back to All Services
                </a>
                <div class="service-icon">
                    <i class="fas fa-laptop-house"></i>
                </div>
                <h1>On-Site Tech Services</h1>
                <p class="lead">Professional technical support at your home or office in East Weymouth and surrounding areas</p>
            </div>
        </div>
    </div>
</section>

<!-- Service Content -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="service-content">
                    <h2>About This Service</h2>
                    <p>Our on-site tech services bring professional technical support directly to your home or business. Whether you're experiencing computer issues, network problems, or need help setting up new equipment, our certified technicians will come to you with the expertise and tools needed to get the job done right.</p>
                    
                    <div class="service-features">
                        <h3>What's Included</h3>
                        <ul class="list-unstyled">
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Diagnostic & Troubleshooting</h5>
                                    <p class="mb-0 text-muted">Comprehensive diagnostic services to identify and resolve technical issues with your devices and network.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Hardware Installation</h5>
                                    <p class="mb-0 text-muted">Professional installation of computers, printers, networking equipment, and other hardware components.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Software Configuration</h5>
                                    <p class="mb-0 text-muted">Setup and configuration of operating systems, applications, and security software to keep your systems running smoothly.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Network Setup & Optimization</h5>
                                    <p class="mb-0 text-muted">Complete home or office network installation, configuration, and optimization for optimal performance.</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    
                    <h3>Why Choose Our On-Site Service?</h3>
                    <p>At Mark's Tech Solution, we understand that technology issues can be frustrating and time-consuming. That's why we bring our expertise directly to you, saving you the hassle of transporting equipment or trying to explain problems over the phone. Our on-site service includes:</p>
                    
                    <ul>
                        <li><strong>Convenience:</strong> We work around your schedule to minimize disruption to your day.</li>
                        <li><strong>Personalized Attention:</strong> One-on-one service with a dedicated technician who will address all your technology needs.</li>
                        <li><strong>No Hidden Fees:</strong> Transparent pricing with no surprises.</li>
                        <li><strong>Local Expertise:</strong> As part of the East Weymouth community, we're familiar with the unique technology needs of our area.</li>
                    </ul>
                    
                    <div class="mt-5 text-center">
                        <a href="../index.php#quote" class="btn btn-primary btn-lg">Schedule On-Site Service</a>
                        <p class="mt-3 text-muted">Have questions? Call us at <a href="tel:6173026011">(617) 302-6011</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include '../components/footer.php'; ?>
