<?php
/**
 * Test script to verify fixes
 */

echo "Testing fixes...\n\n";

// Test 1: Phone Protection
echo "1. Testing Phone Protection:\n";
try {
    require_once 'phone_protection.php';
    global $phoneProtection;
    
    if (class_exists('PhoneProtection')) {
        $phoneProtection = new PhoneProtection();
        $phoneHTML = $phoneProtection->getProtectedPhoneHTML();
        echo "✓ PhoneProtection class works\n";
        echo "✓ Generated HTML: " . substr($phoneHTML, 0, 50) . "...\n";
    } else {
        echo "✗ PhoneProtection class not found after include\n";
    }
} catch (Error $e) {
    echo "✗ Phone protection error: " . $e->getMessage() . "\n";
} catch (Exception $e) {
    echo "✗ Phone protection exception: " . $e->getMessage() . "\n";
}

echo "\n";

// Test 2: Database Connection
echo "2. Testing Database Connection:\n";
try {
    require_once 'Database.php';
    $db = Database::getInstance();
    echo "✓ Database connection successful\n";
    
    // Test recent_submissions view
    $result = $db->fetch("SELECT COUNT(*) as count FROM recent_submissions");
    echo "✓ recent_submissions view works, count: " . $result['count'] . "\n";
    
} catch (Exception $e) {
    if (strpos($e->getMessage(), 'No connection could be made') !== false) {
        echo "⚠ Database server not running (expected for testing)\n";
    } else {
        echo "✗ Database error: " . $e->getMessage() . "\n";
    }
}

echo "\n";

// Test 3: Footer Component
echo "3. Testing Footer Component:\n";
try {
    // Simulate footer inclusion
    ob_start();
    $urlPrefix = '';
    include 'components/footer.php';
    $footerOutput = ob_get_clean();
    
    if (strpos($footerOutput, 'phone-protected') !== false) {
        echo "✓ Footer includes phone protection\n";
    } else {
        echo "✗ Footer missing phone protection\n";
    }
    
    if (strpos($footerOutput, "Mark's Tech Solution") !== false) {
        echo "✓ Footer content loaded correctly\n";
    } else {
        echo "✗ Footer content missing\n";
    }
    
} catch (Exception $e) {
    echo "✗ Footer error: " . $e->getMessage() . "\n";
}

echo "\nAll tests completed!\n";
?>
