<?php

/**
 * Configuration file for Mark's Tech Solution website
 * Store sensitive data in environment variables or a secure config file
 */

// Load environment configuration
if (file_exists(__DIR__ . '/env.php')) {
    include_once __DIR__ . '/env.php';
}

// Environment configuration
class Config {
    private static $config = [
        // reCAPTCHA Configuration
        'recaptcha' => [
            'site_key' => null, // Will be loaded from environment
            'secret_key' => null // Will be loaded from environment
        ],
        
        // Email Configuration
        'email' => [
            'to' => 'm.geden01@markstechsolution.com',
            'from_name' => 'Mark\'s Tech Solution Website',
            'from_email' => 'noreply@markstechsolution.com'
        ],
        
        // Security Configuration
        'security' => [
            'rate_limit_time' => 180, // seconds
            'max_requests' => 1,
            'session_timeout' => 1800 // 30 minutes
        ]
    ];
    
    public static function get($key, $default = null) {
        $keys = explode('.', $key);
        $value = self::$config;
        
        foreach ($keys as $k) {
            if (!isset($value[$k])) {
                return $default;
            }
            $value = $value[$k];
        }
        
        return $value;
    }
    
    public static function getRecaptchaSecretKey() {
        // Try constant first (defined from .env)
        if (defined('RECAPTCHA_SECRET_KEY')) {
            return RECAPTCHA_SECRET_KEY;
        }
        
        // Try to get from environment variable
        $secret = getenv('RECAPTCHA_SECRET_KEY');
        if ($secret) {
            return $secret;
        }
        
        // Fallback to config file (should be secured)
        return self::get('recaptcha.secret_key');
    }
    
    public static function getRecaptchaSiteKey() {
        // Try constant first (defined from .env)
        if (defined('RECAPTCHA_SITE_KEY')) {
            return RECAPTCHA_SITE_KEY;
        }
        
        // Try to get from environment variable
        $siteKey = getenv('RECAPTCHA_SITE_KEY');
        if ($siteKey) {
            return $siteKey;
        }
        
        // Fallback to config file (should be secured)
        return self::get('recaptcha.site_key');
    }
}

// Session security configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1);
ini_set('session.use_strict_mode', 1);
ini_set('session.cookie_samesite', 'Strict');

// Set session timeout
ini_set('session.gc_maxlifetime', Config::get('security.session_timeout'));
?>
