<?php
/**
 * Centralized Navbar Component
 * Edit this file once to update navbar across all pages
 */

// Get current page for active state highlighting
$current_page = basename($_SERVER['PHP_SELF']);
$current_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

$prefix = $urlPrefix ?? '';

// Helper function to determine if a nav item should be active
function isNavActive($href, $currentPage, $currentPath) {
    if (strpos($href, '#') !== false) {
        // Anchor link - never active on page load (handled by scroll)
        return false;
    } else {
        // Regular link - check if it matches current path
        return strpos($currentPath, $href) !== false || $currentPage === basename($href);
    }
}
?>

<!-- Navigation -->
<nav class="navbar navbar-expand-lg navbar-dark fixed-top">
    <div class="container">
        <a class="navbar-brand" href="<?php echo $prefix; ?>index.php">
            <div class="logo-placeholder">MTS</div>
        </a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
       
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <li class="nav-item">
                    <a class="nav-link <?php echo isNavActive('index.php#services', $current_page, $current_path) ? 'active' : ''; ?>" href="<?php echo $prefix; ?>index.php#services">Services</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo isNavActive('contact_form_secure.php', $current_page, $current_path) ? 'active' : ''; ?>" href="<?php echo $prefix; ?>contact_form_secure.php">Request Quote</a>                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo isNavActive('legal-documents.php', $current_page, $current_path) ? 'active' : ''; ?>" href="<?php echo $prefix; ?>legal-documents.php">Privacy & terms and conditions page</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="tel:6173026011">
                        <i class="fas fa-phone-alt me-1"></i> (617) 302-6011
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="mailto:m.geden01@markstechsolution.com?subject=Website%20Inquiry">
                        <i class="fas fa-envelope me-2"></i>Email Us
                    </a>
                </li>
            </ul>
        </div>
    </div>
</nav>