<?php include '../components/header.php'; ?>

<style>
    .service-hero {
        background: linear-gradient(135deg, rgba(255, 102, 0, 0.1) 0%, rgba(204, 82, 0, 0.1) 100%);
        padding: 100px 0 60px;
        margin-top: 76px;
    }
    
    .service-icon {
        font-size: 4rem;
        color: var(--primary-color);
        margin-bottom: 1.5rem;
    }
    
    .service-features {
        background-color: #000000;
        border-radius: 10px;
        padding: 2rem;
        margin: 2rem 0;
        border: 2px solid var(--primary-color);
    }
    
    .feature-item {
        display: flex;
        align-items: flex-start;
        margin-bottom: 1rem;
    }
    
    .feature-item i {
        color: var(--primary-color);
        margin-right: 1rem;
        margin-top: 0.25rem;
    }
    
    .back-to-services {
        display: inline-flex;
        align-items: center;
        margin-bottom: 2rem;
        color: var(--primary-color);
        text-decoration: none;
    }
    
    .back-to-services:hover {
        text-decoration: underline;
    }
    
    .back-to-services i {
        transition: transform 0.3s ease;
        margin-right: 0.5rem;
    }
    
    .back-to-services:hover i {
        transform: translateX(-3px);
    }
</style>

<!-- Hero Section -->
<section class="service-hero">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <a href="../index.php#services" class="back-to-services">
                    <i class="fas fa-arrow-left"></i> Back to All Services
                </a>
                <div class="service-icon">
                    <i class="fas fa-truck-ramp-box"></i>
                </div>
                <h1>Drop-off & Delivery Service</h1>
                <p class="lead">Convenient computer, laptop, and phone service options in East Weymouth and surrounding areas</p>
            </div>
        </div>
    </div>
</section>

<!-- Service Content -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="service-content">
                    <h2>About This Service</h2>
                    <p>For situations where on-site service isn't necessary or when you prefer to bring your device to us, our drop-off and delivery service provides convenient alternatives. Whether you want to drop off your computer at our location or have us pick it up and return it after repairs, we offer flexible options to fit your schedule and needs.</p>
                    
                    <div class="service-features">
                        <h3>Our Service Options Include</h3>
                        <ul class="list-unstyled">
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Drop-off Service</h5>
                                    <p class="mb-0 text-muted">Bring your device to our location for efficient diagnosis and repair.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Pickup & Delivery</h5>
                                    <p class="mb-0 text-muted">We'll pick up your device, repair it at our facility, and deliver it back to you.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Express Service</h5>
                                    <p class="mb-0 text-muted">Priority service for urgent repairs with faster turnaround times.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Remote Support</h5>
                                    <p class="mb-0 text-muted">For software issues, we can often provide remote assistance without you leaving home.</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    
                    <h3>Why Choose Our Drop-off & Delivery Service?</h3>
                    <p>Our flexible service options ensure you get the convenience you need without compromising on quality. We handle your devices with care, provide clear communication throughout the process, and offer competitive pricing for all our services.</p>
                    
                    <div class="mt-5 text-center">
                        <a href="../index.php#quote" class="btn btn-primary btn-lg">Schedule Service</a>
                        <p class="mt-3 text-muted">Have questions? Call us at <a href="tel:6173026011">(617) 302-6011</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include '../components/services_footer.php'; ?>
