<?php
/**
 * Centralized Footer Component
 * Edit this file once to update footer across all pages
 */

// Include phone protection system
require_once __DIR__ . '/../phone_protection.php';
?>

<?php $prefix = $urlPrefix ?? ''; ?>
    
    <!-- Footer -->
    <footer class="bg-dark text-white py-4"> 
        <div class="container">
            <div class="row">
                <div class="col-md-4 mb-3 mb-md-0">
                    <h5>Mark's Tech Solution</h5>
                    <p>Your trusted local tech experts in East Weymouth, MA.</p>
                </div>
                <div class="col-md-4 mb-3 mb-md-0">
                    <h5>Quick Links</h5>
                    <ul class="list-unstyled">
                       <li><a href="https://markstechsolution.com/Main_Site/index.php">Home</a></li>
                            <li><a href="https://markstechsolution.com/Main_Site/index.php#services">Services</a></li>
                            <li><a href="https://markstechsolution.com/Main_Site/contact_form_secure.php">Request a Qoute</a></li>

                    </ul>
                </div>
                <div class="col-md-4">
                    <h5>Contact Info</h5>
                    <address>
                        16 Dale Rd<br>
                        East Weymouth, MA 02189<br>
                        <a href="tel:6173026011" class="text-white"><?php echo $phoneProtection->getProtectedPhoneHTML(); ?></a><br>
                        <a href="mailto:m.geden01@markstechsolution.com?subject=Website%20Inquiry" class="text-white">
                            <img src="./assets/email_icon.png" alt="Email" width="16" height="16" class="me-1">
                            m.geden01@markstechsolution.com
                        </a>
                    </address>
                </div>
            </div>
            <hr class="my-4">
            <div class="text-center">
                <p class="mb-0">&copy; <span id="copyright-year">2026</span> Mark's Tech Solution. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <!-- reCAPTCHA callback function -->
    <script>
      function onSubmit(token) {
        document.getElementById("quoteForm").submit();
      }
    </script>
    
    <!-- Structured Data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "LocalBusiness",
        "name": "Mark's Tech Solution",
        "image": "https://markstechsolution.com/assets/logo.jpg",
        "@id": "https://markstechsolution.com/",
        "url": "https://markstechsolution.com/",
        "telephone": "+1-617-302-6011",
        "email": "m.geden01@markstechsolution.com",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "16 Dale Rd",
            "addressLocality": "East Weymouth",
            "addressRegion": "MA",
            "postalCode": "02189",
            "addressCountry": "US"
        },
        "geo": {
            "@type": "GeoCoordinates",
            "latitude": 42.226008,
            "longitude": -70.945108
        },
        "openingHoursSpecification": [
            {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday"],
                "opens": "10:00",
                "closes": "19:00"
            },
            {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": ["Saturday"],
                "opens": "11:00",
                "closes": "16:00"
            }
        ],
        "sameAs": [
            "https://www.google.com/maps/place/16+Dale+Rd,+East+Weymouth,+MA+02189"
        ],
        "priceRange": "$$",
        "description": "Professional computer repair, network setup, and IT support services in East Weymouth, MA.",
        "serviceArea": {
            "@type": "GeoCircle",
            "geoMidpoint": {
                "@type": "GeoCoordinates",
                "latitude": 42.226008,
                "longitude": -70.945108
            },
            "geoRadius": "25000"
        },
        "hasOfferCatalog": {
            "@type": "OfferCatalog",
            "name": "IT Services",
            "itemListElement": [
                {
                    "@type": "Offer",
                    "itemOffered": {
                        "@type": "Service",
                        "name": "On-Site Tech Support",
                        "description": "Professional tech support at your location"
                    }
                },
                {
                    "@type": "Offer",
                    "itemOffered": {
                        "@type": "Service",
                        "name": "Network Installation",
                        "description": "Wi-Fi and wired network setup and configuration"
                    }
                },
                {
                    "@type": "Offer",
                    "itemOffered": {
                        "@type": "Service",
                        "name": "Computer Repair",
                        "description": "Hardware and software computer repair services"
                    }
                },
                {
                    "@type": "Offer",
                    "itemOffered": {
                        "@type": "Service",
                        "name": "Custom PC Builds",
                        "description": "Custom computer systems tailored to your needs"
                    }
                }
            ]
        }
    }
    </script>
    
    <?php echo $phoneProtection->getProtectionScript(); ?>
    
    <script>
        // Dynamically update copyright year
        document.getElementById('copyright-year').textContent = new Date().getFullYear();
    </script>
</body>
</html>
