<?php include '../components/header.php'; ?>

<style>
    .service-hero {
        background: linear-gradient(135deg, rgba(255, 102, 0, 0.1) 0%, rgba(204, 82, 0, 0.1) 100%);
        padding: 100px 0 60px;
        margin-top: 76px;
    }
    
    .service-icon {
        font-size: 4rem;
        color: var(--primary-color);
        margin-bottom: 1.5rem;
    }
    
    .service-features {
        background-color: #000000;
        border-radius: 10px;
        padding: 2rem;
        margin: 2rem 0;
        border: 2px solid var(--primary-color);
    }
    
    .feature-item {
        display: flex;
        align-items: flex-start;
        margin-bottom: 1rem;
    }
    
    .feature-item i {
        color: var(--primary-color);
        margin-right: 1rem;
        margin-top: 0.25rem;
    }
    
    .back-to-services {
        display: inline-flex;
        align-items: center;
        margin-bottom: 2rem;
        color: var(--primary-color);
        text-decoration: none;
    }
    
    .back-to-services:hover {
        text-decoration: underline;
    }
    
    .back-to-services i {
        transition: transform 0.3s ease;
        margin-right: 0.5rem;
    }
    
    .back-to-services:hover i {
        transform: translateX(-3px);
    }
</style>

<!-- Hero Section -->
<section class="service-hero">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <a href="../index.php#services" class="back-to-services">
                    <i class="fas fa-arrow-left"></i> Back to All Services
                </a>
                <div class="service-icon">
                    <i class="fas fa-network-wired"></i>
                </div>
                <h1>Wired Network Setup</h1>
                <p class="lead">Professional wired network installation for maximum speed, reliability, and security in East Weymouth</p>
            </div>
        </div>
    </div>
</section>

<!-- Service Content -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="service-content">
                    <h2>About This Service</h2>
                    <p>For businesses and homes that demand the highest performance and reliability, wired networks provide superior speed, security, and stability compared to wireless connections. Our professional wired network installation service ensures you get the most reliable and secure network infrastructure for your needs.</p>
                    
                    <div class="service-features">
                        <h3>Our Wired Network Services Include</h3>
                        <ul class="list-unstyled">
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Ethernet Cable Installation</h5>
                                    <p class="mb-0 text-muted">Professional installation of Cat6/Cat7 ethernet cables throughout your property.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Network Switch Configuration</h5>
                                    <p class="mb-0 text-muted">Setup and configuration of managed and unmanaged network switches for optimal performance.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Patch Panel Installation</h5>
                                    <p class="mb-0 text-muted">Professional patch panel setup for organized and manageable network connections.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Network Testing & Certification</h5>
                                    <p class="mb-0 text-muted">Comprehensive testing to ensure all connections meet performance standards.</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    
                    <h3>Why Choose Wired Networks?</h3>
                    <p>Wired networks offer unmatched reliability and performance for critical applications. They're ideal for gaming, streaming, business operations, and any situation where consistent high-speed connectivity is essential.</p>
                    
                    <div class="mt-5 text-center">
                        <a href="../index.php#quote" class="btn btn-primary btn-lg">Schedule Wired Network Installation</a>
                        <p class="mt-3 text-muted">Have questions? Call us at <a href="tel:6173026011">(617) 302-6011</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include '../components/footer.php'; ?>
