<?php include '../components/header.php'; ?>

<style>
    .service-hero {
        background: linear-gradient(135deg, rgba(255, 102, 0, 0.1) 0%, rgba(204, 82, 0, 0.1) 100%);
        padding: 100px 0 60px;
        margin-top: 76px;
    }
    
    .service-icon {
        font-size: 4rem;
        color: var(--primary-color);
        margin-bottom: 1.5rem;
    }
    
    .service-features {
        background-color: #000000;
        border-radius: 10px;
        padding: 2rem;
        margin: 2rem 0;
        border: 2px solid var(--primary-color);
    }
    
    .feature-item {
        display: flex;
        align-items: flex-start;
        margin-bottom: 1rem;
    }
    
    .feature-item i {
        color: var(--primary-color);
        margin-right: 1rem;
        margin-top: 0.25rem;
    }
    
    .back-to-services {
        display: inline-flex;
        align-items: center;
        margin-bottom: 2rem;
        color: var(--primary-color);
        text-decoration: none;
    }
    
    .back-to-services:hover {
        text-decoration: underline;
    }
    
    .back-to-services i {
        transition: transform 0.3s ease;
        margin-right: 0.5rem;
    }
    
    .back-to-services:hover i {
        transform: translateX(-3px);
    }
</style>

<!-- Hero Section -->
<section class="service-hero">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <a href="../index.php#services" class="back-to-services">
                    <i class="fas fa-arrow-left"></i> Back to All Services
                </a>
                <div class="service-icon">
                    <i class="fas fa-tools"></i>
                </div>
                <h1>Service Template</h1>
                <p class="lead">Professional IT services in East Weymouth and surrounding areas</p>
            </div>
        </div>
    </div>
</section>

<!-- Service Content -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="service-content">
                    <h2>About This Service</h2>
                    <p>Professional IT services tailored to meet your specific needs. Our experienced technicians provide reliable solutions for all your technology requirements.</p>
                    
                    <div class="service-features">
                        <h3>What's Included</h3>
                        <ul class="list-unstyled">
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Professional Service</h5>
                                    <p class="mb-0 text-muted">Expert technicians with years of experience in the field.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Quality Assurance</h5>
                                    <p class="mb-0 text-muted">All work is guaranteed to meet your satisfaction.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Competitive Pricing</h5>
                                    <p class="mb-0 text-muted">Fair and transparent pricing with no hidden fees.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Local Support</h5>
                                    <p class="mb-0 text-muted">Based in East Weymouth, serving the local community.</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    
                    <h3>Why Choose Our Service?</h3>
                    <p>We provide reliable, professional IT services with a focus on customer satisfaction and quality workmanship.</p>
                    
                    <div class="mt-5 text-center">
                        <a href="../index.php#quote" class="btn btn-primary btn-lg">Schedule Service</a>
                        <p class="mt-3 text-muted">Have questions? Call us at <a href="tel:6173026011">(617) 302-6011</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include '../components/footer.php'; ?>
