<?php
$pageTitle = 'Network Device Configuration - Mark\'s Tech Solution';
include '../components/header.php';
?>

<style>
    .service-hero {
        background: linear-gradient(135deg, rgba(255, 102, 0, 0.1) 0%, rgba(204, 82, 0, 0.1) 100%);
        padding: 100px 0 60px;
        margin-top: 76px;
    }

    .service-icon {
        font-size: 4rem;
        color: var(--primary-color);
        margin-bottom: 1.5rem;
    }

    .service-features {
        background-color: #000000;
        border-radius: 10px;
        padding: 2rem;
        margin: 2rem 0;
        border: 2px solid var(--primary-color);
    }

    .feature-item {
        display: flex;
        align-items: flex-start;
        margin-bottom: 1rem;
    }

    .feature-item i {
        color: var(--primary-color);
        margin-right: 1rem;
        margin-top: 0.25rem;
    }

    .back-to-services {
        display: inline-flex;
        align-items: center;
        margin-bottom: 2rem;
        color: var(--primary-color);
        text-decoration: none;
    }

    .back-to-services:hover {
        text-decoration: underline;
    }

    .back-to-services i {
        transition: transform 0.3s ease;
        margin-right: 0.5rem;
    }

    .back-to-services:hover i {
        transform: translateX(-3px);
    }
</style>

<!-- Hero Section -->
<section class="service-hero">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto text-center">
                <a href="../index.php#services" class="back-to-services">
                    <i class="fas fa-arrow-left"></i> Back to All Services
                </a>
                <div class="service-icon">
                    <i class="fas fa-cogs"></i>
                </div>
                <h1>Network Device Configuration</h1>
                <p class="lead">Professional router, switch, and modem configuration services in East Weymouth</p>
            </div>
        </div>
    </div>
</section>

<!-- Service Content -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="service-content">
                    <h2>About This Service</h2>
                    <p>Maximize your network's performance and security with professional router, switch, and modem configuration. Whether you're setting up a new device, troubleshooting connectivity issues, or optimizing an existing network, we make sure your equipment is configured correctly and securely.</p>

                    <div class="service-features">
                        <h3>Our Configuration Services Include</h3>
                        <ul class="list-unstyled">
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Router Setup & Optimization</h5>
                                    <p class="mb-0 text-muted">Wi‑Fi setup, DHCP/DNS tuning, guest networks, firewall rules, and performance optimization.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Switch Configuration</h5>
                                    <p class="mb-0 text-muted">VLANs, port configuration, link aggregation, and segmentation for better performance and security.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Modem & Gateway Setup</h5>
                                    <p class="mb-0 text-muted">ISP modem/gateway setup, bridge mode, firmware updates, and stable internet connectivity.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Security Hardening</h5>
                                    <p class="mb-0 text-muted">Secure defaults, strong encryption, remote admin lock-down, and best practices to reduce risk.</p>
                                </div>
                            </li>
                        </ul>
                    </div>

                    <h3>Why Professional Configuration Matters</h3>
                    <p>Correct configuration prevents slow speeds, dropped connections, and security gaps. We verify settings, test connectivity, and leave you with a network that works reliably.</p>

                    <div class="mt-5 text-center">
                        <a href="../index.php#quote" class="btn btn-primary btn-lg">Schedule Network Configuration</a>
                        <p class="mt-3 text-muted">Have questions? Call us at <a href="tel:6173026011">(617) 302-6011</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include '../components/footer.php'; ?>
